// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO FIND AUTOCORRELATION AND CROSSCORRELATION OF THE GIVEN SEQUENCES
clc;
clear;
close;
x=input('Enter the Input Sequence=') //x=[1 2 3 1]
m=length(x);
xl=input('Enter the lower index of Input Sequence=')//0
xh=xl+m-1;
n=xl:1:xh;
subplot(2,2,1);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,x);
title('Input Sequence x[n]');
xlabel('Samples n');
ylabel('Amplitude');

h=input('Enter the Impulse response Sequence=');//h=[1 2 1 1]
l=length(h);
hl=input('Enter the lower index of impulse response Sequence=');//0
hh=hl+l-1;
g=hl:1:hh;
subplot(2,2,2);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',g,h);
title('Impulse Response Sequence h[n]');
xlabel('Samples n');
ylabel('Amplitude');

//Autocorrelation
y=xcorr(x,x);
disp('Auto Correlation Of given Sequence y(n)=');
disp(y);
nx=xl+xl;
nh=xh+xh;
r=nx:nh;
subplot(2,2,3);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,y);
title('Output of Auto Correlation of Sequence');
xlabel('Samples n');
ylabel('Amplitude');

//Cross correlation
z=xcorr(x,h);
disp('Cross Correlation of Sequence y(n)=');
disp(z);
subplot(2,2,4);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,z);
title('Output of Cross correlation of Sequence');
xlabel('Samples n');
ylabel('Amplitude');

//INPUT:
//Enter the Input Sequence=[1 2 3 1]
//Enter the lower index of Input Sequence=0
//Enter the Impulse response Sequence=[1 2 1 1]
//Enter the lower index of impulse response Sequence=0
 
 //OUTPUT:
 //Auto Correlation Of given Sequence y(n)=   
 
   // 1.    5.    11.    15.    11.    5.    1.  
 
 //Cross Correlation of Sequence y(n)=   
 
   // 1.    3.    7.    9.    9.    5.    1.  
 
